class PartialRequest {
    #input_data = []
    #current_request_index
    #response_values
    #part_size
    #requested_data = {}

    constructor(data, part_size)
    {
        this.#current_request_index = 0
        this.#response_values = []
        this.#input_data = data
        this.#part_size = part_size
        this.#requested_data = {}
    }

    set_input_data(data)
    {
        this.#input_data = data
    }

    get_values() {
        this.#current_request_index = 0
        this.#response_values = []
        return this.send_query()
    }

    get_response_values()
    {
        return this.#response_values
    }

    get_requested_data()
    {
        return this.#requested_data
    }

    send_query() {
        let query = ''
        let current_part_index = 0

        //window.clearTimeout(timeoutHandle)

        if ((this.#input_data.length > 0) && (this.#current_request_index < this.#input_data.length) && (current_part_index < this.#part_size))
        {
            query = '/get_od_data.form?'
            let has_request = false
            for (;;)
            {
                if ((this.#current_request_index >= this.#input_data.length) || (current_part_index >= this.#part_size))
                {
                    break;
                }

                if (this.#input_data[this.#current_request_index] != null)
                {
                    if (this.#input_data[this.#current_request_index].AccessType != null)
                    {
                        if (this.#input_data[this.#current_request_index].AccessType.includes('r')) //read
                        {
                            //if (this.#input_data[this.#current_request_index].index != null)
                            if ((this.#current_request_index > 0) && (current_part_index > 0))
                            {
                                query += "&"
                            }
                            has_request = true
                            query += "0x" + this.#input_data[this.#current_request_index].index.replace(":","_")
                            current_part_index++
                            //this.#requested_data.push(this.#input_data[this.#current_request_index])
                            let requested_data_index = this.#input_data[this.#current_request_index].index.replace(":","sub")
                            this.#requested_data[requested_data_index] = this.#input_data[this.#current_request_index]
                            //console.log(this.#requested_data)
                        }
                    }
                }

                this.#current_request_index++
            }

            if (has_request == false)
            {
                //console.log('this.#current_request_index ' + this.#current_request_index)
                query = ''
            }
            //console.log(query)
            //console.log('current_part_index ' + current_part_index)
        }
        return fetch(query)
            .then(response => response.text())
            .then(text => utils.response_ready(text))
            .then(values =>  {
                //console.log(values)
                this.#response_values = this.#response_values.concat(values)
                //console.log(this.#response_values)
                if (this.#current_request_index >= (this.#input_data.length))
                {
                    console.log("end")
                }
                else if (this.#input_data != null)
                {
                    return this.send_query()
                }
            })
    }

    
}